/*
 * Copyright (c) 2008-2014, RF-Embedded GmbH
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.rfe.protocol;

/**
 * Global constants given by RF-Embedded reader host protocol
 */
public class JrfeConstants {
    /** Base index of the payload in package*/
    public static final byte RFE_DATA_BASE_INDEX = 9;

    /** Index of the first start byte*/
    public static final byte RFE_START_INDEX_1 = 0;
    /** Index of the second start byte*/
    public static final byte RFE_START_INDEX_2 = 1;
    /** Index of the third start byte*/
    public static final byte RFE_START_INDEX_3 = 2;
    /** Index of the command start byte*/
    public static final byte RFE_COMMAND_START_INDEX = 3;
    /** Index of the first command*/
    public static final byte RFE_COMMAND_INDEX_1 = 4;
    /** Index of the second command*/
    public static final byte RFE_COMMAND_INDEX_2 = 5;
    /** Index of the length start byte*/
    public static final byte RFE_LENGTH_START_INDEX = 6;
    /** Index of the length*/
    public static final byte RFE_LENGTH_INDEX = 7;	

    /** Index of the payload start byte*/
    public static final byte RFE_PAYLOAD_START_INDEX = 8;	
    /** Index of the payload*/
    public static final byte RFE_PAYLOAD_INDEX = 9;	

    /** Index of the checksum start byte if no payload is in the package*/
    public static final byte RFE_CS_START_WITHOUT_PAYLOAD = 8;	
    /** Index of the checksum if no payload is in the package*/
    public static final byte RFE_CS_WITHOUT_PAYLOAD_INDEX = 9;	


    /** Value of the first start byte = 'R'*/
    public static final byte RFE_START_BYTE_1 = 0x52;
    /** Value of the second start byte = 'F'*/
    public static final byte RFE_START_BYTE_2 = 0x46;
    /** Value of the third start byte = 'E'*/
    public static final byte RFE_START_BYTE_3 = 0x45;	
    /** Value of the command start byte*/
    public static final byte RFE_COMMAND_START_BYTE = 0x01;
    /** Value of the length start byte*/
    public static final byte RFE_LENGTH_START_BYTE = 0x02;	
    /** Value of the payload start byte*/
    public static final byte RFE_PAYLOAD_START_BYTE = 0x03;	
    /** Value of the checksum start byte*/
    public static final byte RFE_CHECKSUM_START_BYTE = 0x04;

    /** Identifier that says that the current inventory round ended*/
    public static final byte RFE_INVENTORY_ROUND_ENDED = 0x00;
    /** Value of the tagId start byte in an inventory answer*/
    public static final byte RFE_TAG_ID_START_BYTE = 0x01;
    /** Value of the rssi start byte in an inventory answer*/
    public static final byte RFE_RSSI_START_BYTE = 0x02;
    /** Value of the user memory start byte in an inventory answer*/
    public static final byte RFE_MEM_START_BYTE = 0x03;
    /** Value of the trigger start byte in an inventory answer*/
    public static final byte RFE_TRIGGER_START_BYTE = 0x04;
    /** Value of the antenna id start byte in an inventory answer*/
    public static final byte RFE_ANTENNA_ID_START_BYTE = 0x05;	
    /** Value of the frequency start byte in an inventory answer*/
    public static final byte RFE_READ_FREQU_START_BYTE = 0x06;	
    /** Value of the handle in an inventory answer*/
    public static final byte RFE_GEN2_HANDLE_START_BYTE = 0x07;
    /** Value of the state start byte in an inventory answer*/
    public static final byte RFE_STATE_START_BYTE = 0x08;
    /** Value of the battery start byte in an inventory answer*/
    public static final byte RFE_BATTERY_START_BYTE = 0x09;
    /** Value of the Gen2 PC in an inventory answer*/
    public static final byte RFE_GEN2_PC_START_BYTE = 0x0A;
    /** Value of the message id in an inventory answer*/
    public static final byte RFE_MESSAGE_ID_START_BYTE = 0x0B;
    /** Data from the application information*/
    public static final byte RFE_APPLICATION_START_BYTE = 0x70;


    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_READER_COMMON = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_SERIAL_NUMBER = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_READER_TYPE = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_HARDWARE_REVISION = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_SOFTWARE_REVISION = 0x04;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_BOOTLOADER_REVISION = 0x05;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_CURRENT_SYSTEM = 0x06;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_CURRENT_STATE = 0x07;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_STATUS_REGISTER = 0x08;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_ANTENNA_COUNT = 0x10;

    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_READER_RF = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_ATTENUATION = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_FREQUENCY = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_SENSITIVITY = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_LBT_PARAMS = 0x04;
        /** Command definition, can be found in the protocol description*/
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_ATTENUATION = (byte) 0x81;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_FREQUENCY = (byte) 0x82;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_SENSITIVITY = (byte) 0x83;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_LBT_PARAMS = (byte) 0x84;

    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_READER_CONTROL = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_REBOOT = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_HEARTBEAT = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_ANTENNA_POWER = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_RESTORE_FACTORY_SETTINGS = 0x20;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SAVE_SETTINGS_PERMANENT = 0x21;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_PARAM = 0x30;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_PARAM = 0x31;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_DEVICE_NAME = 0x32;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_DEVICE_NAME = 0x33;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_DEVICE_LOCATION = 0x34;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_DEVICE_LOCATION = 0x35;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SWITCH_SYSTEM = (byte) 0xFE;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_BOOTLOADER_COMMAND = (byte) 0xFF;


    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_READER_TAG_MODE = 0x04;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_TAG_MODE = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_CURRENT_TAG_MODE = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_TAG_FUNCTION_LIST = 0x03;

    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_READER_GPIO = 0x05;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_GPIO_CAPS = 0x01;
        /** Command definition, can be found in the protocol description*/
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_GPIO_DIRECTION = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_GPIO_DIRECTION = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_GPIO = 0x04;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_GPIO = 0x05;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_CLEAR_GPIO = 0x06;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_CLEAR_SET_GPIO = 0x07;

    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_READER_ANTENNA = 0x06;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_ANTENNA_SEQUENCE = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_ANTENNA_SEQUENCE = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_SET_WORKING_ANTENNA = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_WORKING_ANTENNA = 0x04;


    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_NOTIFICATION = 0x10;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_ACTIVATE_NOTIFICATION = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_DEACTIVATE_NOTIFICATION = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GET_ACTIVE_NOTIFICATION = 0x03;

    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_TAG_FUNCTIONS = 0x50;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_INVENTORY_SINGLE = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_INVENTORY_CYCLIC = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_READ_FROM_TAG = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_WRITE_TO_TAG = 0x04;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_LOCK_TAG = 0x05;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_KILL_TAG = 0x06;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_CUSTOM_TAG_COMMAND = 0x10;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_READ_MULTIPLE_FROM_TAG = 0x20;

    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_APPLICATION = 0x70;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_APPLICATION_CALL = 0x01;

    /** Command definition, can be found in the protocol description*/
    public static final byte RFE_COM1_INTERRUPT = (byte) 0x90;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_HEARTBEAT_INTERRUPT = 0x01;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_INVENTORY_CYCLIC_INTERRUPT = 0x02;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_STATE_CHANGED_INTERRUPT = 0x03;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_STATUS_REG_CHANGED_INTERRUPT = 0x04;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_BOOT_UP_FINISHED_INTERRUPT = 0x05;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_NOTIFICATION_INTERRUPT = 0x06;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_APPLICATION_INTERRUPT = 0x07;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_OPERATION_RESULT_INTERRUPT = 0x08;
        /** Command definition, can be found in the protocol description*/
        public static final byte RFE_COM2_GPIO_PINS_CHANGED = 0x09;

    /** Return codes of the request handler that are also sent to the host*/
    public static class eRFE_RET_VALUE
    {
        /** Only internal return code that means there is nothing to do*/
    	public static final int RFE_RET_NOTHING_TODO = -1;
        /** Operation was successfull*/
    	public static final int RFE_RET_SUCCESS = 0x00;	
        /** Operation result not present; is sent after operation done*/
    	public static final int RFE_RET_RESULT_PENDING = 0x01;
        /** Operation is not supported*/
    	public static final int RFE_RET_ERR_OP_NOT_SUPPORTED = 0x50;
        /** An unknwon error occured*/
    	public static final int RFE_RET_ERR_UNKOWN_ERR = 0x51;
        /** While executing operation an error occured*/
    	public static final int RFE_RET_ERR_ON_EXEC_OP = 0x52;
        /** The write operation could not be performed*/
    	public static final int RFE_RET_ERR_COULD_NOT_WRITE = 0x53;
        /** The param count of a request was wrong*/
    	public static final int RFE_RET_ERR_WRONG_PARAM_COUNT = 0x54;
        /** A param of a request was wrong*/
    	public static final int RFE_RET_ERR_WRONG_PARAM = 0x55;	
        /** Gen2 Error: Tag is not in the range of the reader*/
    	public static final int RFE_RET_TMI_TAG_UNREACHABLE = 0xA0;	
        /** Gen2 Error: Memory overrun -> address does not exist*/
    	public static final int RFE_RET_TMI_MEM_OVERRUN = 0xA1;	
        /** Gen2 Error: Memory of the tag is locked*/
    	public static final int RFE_RET_TMI_MEM_LOCKED = 0xA2;
        /** Gen2 Error: The tag has too less power*/
    	public static final int RFE_RET_TMI_INSUFFICIENT_POWER = 0xA3;	
        /** Gen2 Error: The tag's state was not taken to secured*/
    	public static final int RFE_RET_TMI_WRONG_PASSWORD = 0xA4;
    	
    	public static String toString(int value)
    	{
    		switch((value & 0xFF))
    		{
    		case RFE_RET_NOTHING_TODO:
    			return "RFE_RET_NOTHING_TODO";
    		case RFE_RET_SUCCESS:
    			return "RFE_RET_SUCCESS";
    		case RFE_RET_RESULT_PENDING:
    			return "RFE_RET_RESULT_PENDING";
    		case RFE_RET_ERR_OP_NOT_SUPPORTED:
    			return "RFE_RET_ERR_OP_NOT_SUPPORTED";
    		case RFE_RET_ERR_UNKOWN_ERR:
    			return "RFE_RET_ERR_UNKOWN_ERR";
    		case RFE_RET_ERR_ON_EXEC_OP:
    			return "RFE_RET_ERR_ON_EXEC_OP";
    		case RFE_RET_ERR_COULD_NOT_WRITE:
    			return "RFE_RET_ERR_COULD_NOT_WRITE";
    		case RFE_RET_ERR_WRONG_PARAM_COUNT:
    			return "RFE_RET_ERR_WRONG_PARAM_COUNT";
    		case RFE_RET_ERR_WRONG_PARAM:
    			return "RFE_RET_ERR_WRONG_PARAM";
    		case RFE_RET_TMI_TAG_UNREACHABLE:
    			return "RFE_RET_TMI_TAG_UNREACHABLE";
    		case RFE_RET_TMI_MEM_OVERRUN:
    			return "RFE_RET_TMI_MEM_OVERRUN";
    		case RFE_RET_TMI_MEM_LOCKED:
    			return "RFE_RET_TMI_MEM_LOCKED";
    		case RFE_RET_TMI_INSUFFICIENT_POWER:
    			return "RFE_RET_TMI_INSUFFICIENT_POWER";
    		case RFE_RET_TMI_WRONG_PASSWORD:
    			return "RFE_RET_TMI_WRONG_PASSWORD";
			default:
				return "UNKNOWN";
    		}
    	}
    };

    /** Typedef for the current state*/
    public static class eRFE_CURRENT_READER_STATE
    {
        /** Idle state*/
    	public static final int RFE_STATE_IDLE	= 0x00;
        /** Rebooting state*/
    	public static final int RFE_STATE_REBOOTING = 0x01;
        /** Scanning state*/
    	public static final int RFE_STATE_SCANNING = 0x10;
        /** Writing state*/
    	public static final int RFE_STATE_WRITING = 0x11;
        /** Reading state*/
    	public static final int RFE_STATE_READING = 0x12;
    	
    	public static String toString(int value)
    	{
    		switch((value & 0xFF))
    		{
    		case RFE_STATE_IDLE:
    			return "RFE_STATE_IDLE";
    		case RFE_STATE_REBOOTING:
    			return "RFE_STATE_REBOOTING";
    		case RFE_STATE_SCANNING:
    			return "RFE_STATE_IDLE";
    		case RFE_STATE_WRITING:
    			return "RFE_STATE_WRITING";
    		case RFE_STATE_READING:
    			return "RFE_STATE_READING";
			default:
				return "UNKNOWN";
    		}
    	}
    };


    /** Typedef for current system*/
    public static class eRFE_CURRENT_SYSTEM
    {
        /** Bootloader system*/
    	public static final int RFE_SYS_BOOTLOADER = 0x22;
        /** Firmware system*/
    	public static final int RFE_SYS_FIRMWARE = 0xBB;
    	
    	public static String toString(int value)
    	{
    		switch((value & 0xFF))
    		{
    		case RFE_SYS_BOOTLOADER:
    			return "RFE_SYS_BOOTLOADER";
    		case RFE_SYS_FIRMWARE:
    			return "RFE_SYS_FIRMWARE";
			default:
				return "UNKNOWN";
    		}
    	}
    };

    /** Typedef for heartbeat parameter*/
    public class eRFE_HEARTBEAT_SIGNAL
    {
        /** Turns heartbeat off*/
    	public static final int HEARTBEAT_OFF = 0x00;
        /** Turns heartbeat on*/
    	public static final int HEARTBEAT_ON = 0x01;
        /** Turns heartbeat duplex on*/
    	public static final int HEARTBEAT_DUPLEX = 0x02;
        /** Turns heartbeat with state on*/
    	public static final int HEARTBEAT_STATE_ON = 0x03;
        /** Turns heartbeat duplex with state on*/
    	public static final int HEARTBEAT_STATE_DUPLEX = 0x04;
    };


    /** Typedef for antenna power parameter*/
    public class eRFE_ANTENNA_POWER
    {
        /** Turns antenna power on*/
    	public static final int ANTENNA_OFF = 0x00;
        /** Turns antenna power off*/
    	public static final int ANTENNA_ON = 0x01;
    };


    /** Typedef for tag types*/
    public class eRFE_TAG_MODE
    {
        /** ISO 6B tags*/
    	public static final int ISO_18000_6_B = 0x40;
        /** ISO 6C / Gen2 tags*/
    	public static final int ISO_18000_6_C = 0x41;
        /** RFE active tags*/
    	public static final int RFE_ACTIVE_01 = 0xC0;
        /** RFE active tags*/
    	public static final int RFE_ACTIVE_02 = 0xC1;
    };


    /** Typedef for cyclic inventory parameter*/
    public class eRFE_INVENTORY_MODE
    {
        /** Turns cyclic inventory on*/
    	public static final int INVENTORY_OFF = 0x00;
        /** Turns cyclic inventory off*/
    	public static final int INVENTORY_ON = 0x01;
    };


    /** Typedef for the trigger sources*/
    public class eRFE_TRIGGER_SOURCE
    {
        /** No trigger*/
    	public static final int TRIGGER_NONE = 0x00;
        /** Button trigger*/
    	public static final int TRIGGER_BUTTON = 0x01;
    };


    /** Message states for parsing incomming data*/
    public enum eMessageState
    {
        /** Start byte #1*/
        START_BYTE_1,
        /** Start byte #2*/
        START_BYTE_2,
        /** Start byte #3*/
        START_BYTE_3,
        /** Command start byte*/
        COMMAND_START_BYTE,
        /** Command byte #1*/
        COMMAND_1,
        /** Command byte #2*/
        COMMAND_2,
        /** Length start byte*/
        LENGTH_START_BYTE,
        /** Length byte*/
        LENGTH,
        /** Payload start byte*/
        PAYLOAD_START_BYTE,
        /** Paylod bytes*/
        PAYLOAD,
        /** Checksum start byte*/
        CHECKSUM_START_BYTE,
        /** Checksum*/
        CHECKSUM
    };

    /** The different satets for parsing cyclic inventory isr*/
    public enum eInventoryMessageState
    {
        /** Start byte*/
        START,
        /** Inventory end indicator*/
        INVENTORY_END_INDICATOR,
        /** Tag Id length*/
        TAGID_LENGTH,
        /** Tag Id*/
        TAGID,
        /** RSSI byte #1*/
        RSSI1,
        /** RSSI byte #2*/
        RSSI2,
        /** Mem bank*/
        MEM_BANK,
        /** Mem address byte #1*/
        MEM_ADDR1,
        /** Mem address byte #2*/
        MEM_ADDR2,
        /** Mem size*/
        MEM_SIZE,
        /** Mem data*/
        MEM_DATA,
        /** Trigger*/
        TRIGGER,
        /** Antenna*/
        ANTENNA,
        /** Frequency byte #1*/
        FREQUENCY1,
        /** Frequency byte #2*/
        FREQUENCY2,
        /** Frequency byte #3*/
        FREQUENCY3,
        /** Handle byte #1*/
        HANDLE1,
        /** Handle byte #2*/
        HANDLE2,
        /** State byte #1*/
        STATE1,
        /** State byte #2*/
        STATE2,
        /** Battery indicator*/
        BATTERY,
        /** PC byte #1*/
        PC1,
        /** PC byte #2*/
        PC2,
        /** Message ID indicator*/
        MESSAGE_ID,
        /** Application size indicator*/
        APPLICATION_SIZE,
        /** Application data indicator*/
        APPLICATION_DATA,
    };
}
